﻿using Helper;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using ZSMusic.IDAL;
using ZSMusic.Model;


namespace ZSMusic.DAL.Platforms
{
    public class wy : IMusic
    {
        public List<Music> Search(string word, int page, int num)
        {
            List<Music> list = new List<Music>();
            string src = HttpHelper.Get(string.Format(
            "http://yinle.rzzkk520.cn/api.php?callback=jQuery11130182920795747622_1585018563804&types=search&count={0}&source=netease&pages={1}&name={2}"
            , num, page, word));
            Regex rg = new Regex("\"id\":(.*?),\"name\":\"(.*?)\",\"artist\":\\[\"(.*?)\"\\],\"album\":\"(.*?)\",\"pic_id\":\"(.*?)\",\"url_id\":.*?,\"lyric_id\":(.*?),\"source");
            MatchCollection col = rg.Matches(src);
            foreach (Match i in col)
            {
                Music s = new Music();
                s.Id = i.Groups[1].Value;
                s.Name = i.Groups[2].Value;
                s.Artist = i.Groups[3].Value;
                s.Album = i.Groups[4].Value;
                s.AlbumId = i.Groups[5].Value;
                s.Source = "wy";
                s.ToString();
                list.Add(s);
            }
            return list;
        }

        public List<Music> SearchCollection(string id)
        {//http://ali.asdi998.com:880/
            //http://yinle.rzzkk520.cn
            List<Music> list = new List<Music>();
            string src = HttpHelper.Get(string.Format(
            "http://www.hackhp.com/demo/MKOnlineMusicPlayer/api.php?callback=jQuery11130915479096928357_1587695091669&types=playlist&id={0}&_=1587695091671"
            , id));
            if (!src.Contains("{["))
            {
                src = HttpHelper.Get(string.Format(
                    "http://www.hackhp.com/demo/MKOnlineMusicPlayer/api.php?callback=jQuery11130915479096928357_1587695091669&types=playlist&id={0}&_=1587695091671"
                    , id));
            }
            string[] infos = StringEx.GetMiddleTextMultiple(src, "{\"n", "\"vd\"");
            foreach (string i in infos)
            {
                Music s = new Music();
                s.Id = StringEx.GetMiddleText(i, "id\":", ",\"pst");
                s.Artist = StringEx.GetMiddleText(i, "\"name\":\"", "\",\"tns");
                s.Name = StringEx.GetMiddleText(i, "ame\":\"", "\",\"id\":");
                s.Album = StringEx.GetMiddleText(i, "", "");
                s.AlbumId = StringEx.GetMiddleText(i, "picUrl\":\"", "\",\"tns").Replace("\\", "");
                s.Source = "wy";
                s.ToString();
                list.Add(s);

            }
            return list;
        }

        public List<Music> SearchAlbum(string id)
        {
            throw new NotImplementedException();
        }

        public bool GetData(Music m, string type = "all")
        {
            switch (type)
            {
                case "all":
                    GetPic(m);
                    GetLrc(m);
                    return GetUrl(m);
                case "url":
                    return GetUrl(m);
                case "pic":
                    return GetPic(m);
                case "lrc":
                    return GetLrc(m);
                default:
                    throw new NotImplementedException();
            }
        }

        private bool GetUrl(Music m)
        {
            //string Src = HttpHelper.Redirect(string.Format(
            //"http://music.163.com/song/media/outer/url?id={0}.mp3"
            //, m.Id));
            //m.Url = Src;
            //if (m.Url.Contains("404"))
            //{ m.Url = ""; }
            //return HttpHelper.CheckUri(m.Url);
            string Src = StringEx.GetMiddleText(HttpHelper.Get(string.Format(
"http://yinle.rzzkk520.cn/api.php?callback=jQuery11130182920795747622_1585018563804&types=url&id={0}&source=netease"
, m.Id)), "jQuery11130182920795747622_1585018563804(", ")");//.Trim(new char[]{'(',')'});
            m.Url = StringEx.ExactJson(Src, "url").Replace("\\", "");
            if (m.Url.Contains("song/media/outer"))
            { m.Url = ""; }
            return HttpHelper.CheckUri(m.Url);
        }

        private bool GetLrc(Music m)
        {
            string Lrcsrc = HttpHelper.Get(string.Format(
            "http://yinle.rzzkk520.cn/api.php?callback=jQuery11130182920795747622_1585018563804&types=lyric&id={0}&source=netease"
            , m.Id));
            m.Lrc = StringEx.GetMiddleText(Lrcsrc, "lyric\":\"", "\",\"tlyric").Trim()
            .Replace("\\n", "\n").Replace("\\r", "");
            return !string.IsNullOrWhiteSpace(m.Lrc);
        }

        private bool GetPic(Music m)
        {
            if (string.IsNullOrWhiteSpace(m.AlbumId))
            { return false; }
            if (m.AlbumId.Contains("http")) { m.PicUrl = m.AlbumId; }
            else
            {
                string picsrc = HttpHelper.Get(string.Format(
                "http://yinle.rzzkk520.cn/api.php?callback=jQuery11130182920795747622_1585018563804&types=pic&id={0}&source=netease"
                , m.AlbumId));
                m.PicUrl = StringEx.GetMiddleText(picsrc, "url\":\"", "\"})").Replace("\\", "");
            }
            return HttpHelper.CheckUri(m.PicUrl);
        }


    }
}
